package cn.tee3.dev.activity.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.List;

import rtc.User;
import cn.tee3.dev.R;

/**
 * Created by pjy on 2017/4/20.
 */

public class UserRecyclerViewAdapter extends RecyclerView.Adapter<UserRecyclerViewAdapter.InnerViewHolder> {

    private final Context context;
    private List<User> userList;

    public UserRecyclerViewAdapter(Context context, List<User> userList){
        this.context = context;
        this.userList = userList;
    }

    @NonNull
    @Override
    public InnerViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(context).inflate(R.layout.user_recycler_view_layout, parent, false);
        return new InnerViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull InnerViewHolder holder, int position) {
        User user = userList.get(position);
        holder.tvName.setText(user.getUserName());
        User.UserStatus userStatus = user.getStatus();
        userStatus.isVideoOn();
        userStatus.isAudioOn();
        if (userStatus.hasCamera()) {
            holder.ivIsOpenCamera.setVisibility(View.VISIBLE);
            holder.ivIsOpenCamera.setImageResource(userStatus.isVideoOn() ? R.drawable.img_open_camera : R.drawable.img_close_camera);
        }else {
            holder.ivIsOpenCamera.setVisibility(View.INVISIBLE);
        }

        if (userStatus.hasMicrophone()) {
            holder.ivIsOpenMicrophone.setVisibility(View.VISIBLE);
            holder.ivIsOpenMicrophone.setImageResource(userStatus.isAudioOn() ? R.drawable.img_open_microphone : R.drawable.img_close_microphone);
        } else {
            holder.ivIsOpenMicrophone.setVisibility(View.INVISIBLE);
        }
    }

    @Override
    public int getItemCount() {
        return userList.size();
    }

    class InnerViewHolder extends RecyclerView.ViewHolder{
        public TextView tvName;
        public ImageView ivIsOpenCamera;
        public ImageView ivIsOpenMicrophone;
        public InnerViewHolder(View view) {
            super(view);
            tvName= view.findViewById(R.id.tv_userName);
            ivIsOpenCamera=  view.findViewById(R.id.iv_isOpenCamera);
            ivIsOpenMicrophone=  view.findViewById(R.id.iv_isOpenMicrophone);
        }
    }

    public void updateUserList(List<User> userList) {
        this.userList.clear();
        this.userList.addAll(userList);
        notifyDataSetChanged();
    }
}
