package cn.tee3.dev.activity.utils;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.support.v4.content.ContextCompat;

import com.tbruyelle.rxpermissions2.Permission;
import com.tbruyelle.rxpermissions2.RxPermissions;

import java.util.ArrayList;
import java.util.List;

import rtc.Tlog;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;

/**
 * 动态权限获取
 */
public class RequestPermissions {
    private static RxPermissions rxPermissions;
    private static Disposable disposable;
    private static Activity activity;
    private static Helper helper;
    private static List<String> permissionList;

    public enum PermissionCode {
        GRANTED,
        REFUSE,
        NO_LONGER_ASK
    }

    public static Helper permissionHelper(Activity activity) {
        if (permissionList == null) {
            permissionList = new ArrayList<>();
            permissionList.add(Manifest.permission.CAMERA);
            permissionList.add(Manifest.permission.RECORD_AUDIO);
            permissionList.add(Manifest.permission.READ_EXTERNAL_STORAGE);
            permissionList.add(Manifest.permission.WRITE_EXTERNAL_STORAGE);
            permissionList.add(Manifest.permission.READ_PHONE_STATE);
        }
        if (RequestPermissions.activity != activity) {
            RequestPermissions.activity = activity;
            rxPermissions = new RxPermissions(activity);
        }
        helper = new Helper();
        return helper;
    }

    public void dispose() {
        activity = null;
        rxPermissions = null;
        helper = null;
        if (disposable != null) {
            disposable.dispose();
        }
    }

    public static class Helper {
        private RxPermissions objCheck() {
            if (rxPermissions == null && activity != null) {
                rxPermissions = new RxPermissions(activity);
            }
            return rxPermissions;
        }

        @SuppressLint("CheckResult")
        public void request(final String permissions, PermissionRequestCallback callback) {
            disposable = objCheck().requestEach(permissions)
                    .subscribe(new Consumer<Permission>() {
                        @Override
                        public void accept(Permission permission) {
                            if (callback != null) {
                                callback.onRequestCallback(permission);
                                if (permission.granted) {
                                    Tlog.d("RequestPermissions", permission.name + " ->  granted");
                                    callback.onGranted(permission.name);
                                } else if (permission.shouldShowRequestPermissionRationale) {
                                    Tlog.d("RequestPermissions", permission.name + " ->  refused");
                                    callback.onRefused(permission.name);
                                } else {
                                    Tlog.d("RequestPermissions", permission.name + " ->  noLongerAsk");
                                    callback.onNoLongerAsk(permission.name);
                                }
                            }
                        }
                    });
        }

        @SuppressLint("CheckResult")
        public void request(PermissionRequestCallback callback, final String... permissions) {
            for (String code : permissions) {
                request(code, callback);
            }
        }

        public boolean isGranted(String permission) {
            objCheck();
            return rxPermissions.isGranted(permission);
        }

        public boolean isGranted(List<String> permissionList) {
            objCheck();
            for (String permission : permissionList) {
                boolean granted = rxPermissions.isGranted(permission);
                if (!granted) {
                    return false;
                }
            }
            return true;
        }
    }

    public boolean isGranted(Context context, String permission) {
        return ContextCompat.checkSelfPermission(context, permission) == PackageManager.PERMISSION_GRANTED;
    }

    public interface PermissionRequestCallback {
        void onRequestCallback(Permission permission);

        void onGranted(String code);

        void onRefused(String code);

        void onNoLongerAsk(String code);
    }
}
